// bmd import
// carsten kolve, 04.2000

@version 2.0
@warnings
@script generic


generic
{

	// create gui
   
    return if !reqbegin("bugzMotionData Import (c) 04.00 Carsten.Kolve@gmx.de");

    c0 = ctlfilename("Choose bmd-File","*.bmd");
    c1 = ctlnumber("Scale Values by",1.0);
    c2 = ctlfilename("Choose lwo-File","*.lwo");
    c3 = ctltext("","(leave blank to create NULL-Objects)");
    c4 = ctlcheckbox("Parent Members to Group",true);
    c5 = ctlcheckbox("Align Member Heading to Path",true);
    
	// get values from gui

    if(reqpost())
    {
        bmdFileName = getvalue(c0);
        scaleFactor = getvalue(c1);
        lwoFileName = getvalue(c2);
        parentBool =  getvalue(c4);
        pathBool = getvalue(c5);
    }
    else
      return;

    reqend();
  
  
   directory = recall("directory","C:\\");

	// error handling

   if (!	fileexists(bmdFileName))
   {
      error("Specified file does not exist, quitting!");
      return;
   }
   
   lwoExchange = fileexists(lwoFileName);
   
   base = split(bmdFileName);

   directory = string(base[1],base[2]);

   store("directory",directory);

	// open file

   bmdFile = File(bmdFileName,"r");

   if(bmdFile == nil)
   {
      error("Cannot open bmdMotion File \"",bmdFileName,"\""+", quitting!");
      return;
   }
   
	// get scene information

   scene = getfirstitem(SCENE);
   fps = scene.fps;
   
	// get group information

   groupdata = bmdFile.parse(";"); 
   groupname = groupdata[1];
   membercount = integer(groupdata[2]);
   
	// create group null

   if (parentBool)
   {
     AddNull(groupname);
     group = getfirstitem(groupname);
   }
   
	// load group members

   for index1 = 1 to membercount do
   {

		// get member information

      memberdata = bmdFile.parse(";");
      membername = memberdata[1];
      keycount = integer(memberdata[2]);


		// create member null
		
      
      AddNull(membername);
      member = getfirstitem(membername);
      
      if (parentBool)
      {
        ParentItem(groupname);
      }
      
		// store first key (lw bug: first key must be set last)

      firstkeydata = bmdFile.parse(";");

      for index2 = 1 to keycount do
      {

			// read key information and set key
      
         keydata = bmdFile.parse(";");
         Position(number(keydata[2])*scaleFactor,number(keydata[3])*scaleFactor,number(keydata[4])*scaleFactor);
         CreateKey(integer(keydata[1])/fps);
      }
      
		// set first key

      Position(number(firstkeydata[2])*scaleFactor,number(firstkeydata[3])*scaleFactor,number(firstkeydata[4])*scaleFactor);
      CreateKey(integer(firstkeydata[1])/fps);

		// allign member null heading to motion path
      
      if (pathBool)
      {
         HController(2);      
      }

		// exchange null with object file
		
		if (lwoExchange)
		{
		   ReplaceWithObject(lwoFileName);
		}
		
   }
 
   bmdFile.close(); 

}